# Orthogonal Classifier



### Evaluate the orthogonal classifier 

Datasets: ColoredMNIST

- Orthogonal classifier:

  ```bash
  sh scripts/run.sh <bias>
  
  bias: The bias degree on the back-ground colors
  ```

- Oracle:

  ```bash
  python -m train_oracle   --data_dir=../domainbed \
  --algorithm ERM  --dataset ColoredMNIST  --trial_seed 0 --bias 0. bias --epochs 1
  
  bias: The bias degree on the back-ground colors
  ```

- Reweighed classifier:

  ```bash
  sh scripts/run_reweight.sh <bias>
  
  bias: The bias degree on the back-ground colors
  ```

  

### Style Transfer

- To view training results and loss plots, run `python -m visdom.server` and click the URL [http://localhost:8097](http://localhost:8097/)

- MINIT-C:

  ```shell
  python train_cyclegan.py --dataroot root --model cycle_gan --pool_size 50 --no_dropout \
  --gan_mode vanilla --name vanilla --eval --netG mnist \
  --netD mnist --dataset ColoredMNIST --bias 0.9 0.8 0.8 --batch_size 128 --obj obj
  
  root: data root
  obj: vanilla | kl | js
  
  
  # example
  python train_cyclegan.py --dataroot ./datasets --model cycle_gan --pool_size 50 --no_dropout \
  --gan_mode vanilla --name mnist_js_mldg --eval --netG mnist \
  --netD mnist --dataset ColoredMNIST --bias 0.9 0.8 0.8 --batch_size 128 --obj js
  ```

  

- CelebA:

  

  - Train invariant CycleGAN (JS-divergence): 

  ```shell
  # pretrain
  
  # pretrain celeba
  python train_cyclegan.py --dataroot root  \
  --model cycle_gan --pool_size 50 --no_dropout \
  --gan_mode vanilla  --eval --netG unet_128 --netD basic \
  --dataset Celeba  --batch_size 32 --obj onj --print_freq 500 --name name --n_epochs 12 --image_size 128
  
  
  root: data root
  obj: vanilla | kl | js
  ```

  






